unit XDividerLabel;

{
  TXDividerLabel 1.0 (1999-09-12)
  ==================
  A component for dividing of component group ala Outlook 2000.

  Freeware.

  Copyright  1999 Roman Stedronsky, Roman.Stedronsky@seznam.cz.

  All rights reserved. You may use this software in an application
  without fee or royalty, provided this copyright notice remains intact.

  properties:
    property Edge: integer;	distance between line and text
}

interface

uses
  Windows, Classes, Graphics, StdCtrls;

type
  TXDividerLabel = class(TCustomLabel)
  private
    FEdge: integer;
    procedure SetEdge(Value: integer);
  protected
    procedure Paint; override;
    property AutoSize default false;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property Edge: integer read FEdge write SetEdge default 5;
  published
    property Align;
    property Alignment;
    property Anchors;
    property BiDiMode;
    property Caption;
    property Color;
    property Constraints;
    property DragCursor;
    property DragKind;
    property DragMode;
    property Enabled;
    property FocusControl;
    property Font;
    property ParentBiDiMode;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowAccelChar;
    property ShowHint;
    property Transparent;
    property Layout;
    property Visible;
    property WordWrap;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDock;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDock;
    property OnStartDrag;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Extra', [TXDividerLabel]);
end;

{ TXDividerLabel }

constructor TXDividerLabel.Create;
begin
  inherited;
  FEdge := 5;
  AutoSize := false;
  Width := Width + 150; 
end;

procedure TXDividerLabel.Paint;
const
  Alignments: array[TAlignment] of Word = (DT_LEFT, DT_RIGHT, DT_CENTER);
  WordWraps: array[Boolean] of Word = (0, DT_WORDBREAK);
var
  CalcRect: TRect;
  DrawStyle: Longint;
  R: TRect;
  X1, X2: integer;
  H: integer;
begin
  with Canvas do
  begin
  end;
  with Canvas do
  begin
    if not Transparent then
    begin
      Brush.Color := Self.Color;
      Brush.Style := bsSolid;
      FillRect(ClientRect);
    end;
    // NEW PART OF COMPONENT
    H := TextHeight('0') div 2;
    case Alignment of
      taCenter:
        begin
          X1 := 0; X2 := (Width div 2) - (TextWidth(Caption) div 2) - FEdge;
          Pen.Color := clBtnShadow;
          MoveTo(X1, H - 1);
          LineTo(X2, H - 1);
          Pen.Color := clBtnHighlight;
          MoveTo(X1, H);
          LineTo(X2, H);
          X1 := (Width div 2) + (TextWidth(Caption) div 2) + FEdge;
          X2 := Width;
        end;
      taLeftJustify:
        begin X1 := TextWidth(Caption) + FEdge; X2 := Width; end;
    else //taRightJustify:
      begin X1 := 0; X2 := Width - TextWidth(Caption) - FEdge; end;
    end;
    Pen.Color := clBtnShadow;
    MoveTo(X1, H - 1);
    LineTo(X2, H - 1);
    Pen.Color := clBtnHighlight;
    MoveTo(X1, H);
    LineTo(X2, H);
    // END OF NEW PART OF COMPONENT
    Brush.Style := bsClear;
    R := ClientRect;
    { DoDrawText takes care of BiDi alignments }
    DrawStyle := DT_EXPANDTABS or WordWraps[WordWrap] or Alignments[Alignment];
    { Calculate vertical layout }
    if Layout <> tlTop then
    begin
      CalcRect := R;
      DoDrawText(CalcRect, DrawStyle or DT_CALCRECT);
      if Layout = tlBottom then
        OffsetRect(R, 0, Height - CalcRect.Bottom)
      else
        OffsetRect(R, 0, (Height - CalcRect.Bottom) div 2);
    end;
    DoDrawText(R, DrawStyle);
  end;
end;

procedure TXDividerLabel.SetEdge(Value: integer);
begin
  FEdge := Value;
  Refresh;
end;

end.

